//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;
using System.Diagnostics;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Reflection;
using System.Windows.Forms;
using System.Runtime.Remoting;
using System.Runtime.Remoting.MetadataServices;

namespace WeatherProg
{
	/// <summary>
	/// Podsumowanie dla WeatherForm.
	/// </summary>
	public class WeatherForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox url;
		private System.Windows.Forms.Button initializeButton;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public WeatherForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.url = new System.Windows.Forms.TextBox();
			this.initializeButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// url
			// 
			this.url.Location = new System.Drawing.Point(8, 56);
			this.url.Name = "url";
			this.url.ReadOnly = true;
			this.url.Size = new System.Drawing.Size(312, 20);
			this.url.TabIndex = 0;
			this.url.Text = "http://www.vbws.com/services/weatherretriever.asmx?WSDL";
			// 
			// initializeButton
			// 
			this.initializeButton.Location = new System.Drawing.Point(8, 16);
			this.initializeButton.Name = "initializeButton";
			this.initializeButton.TabIndex = 1;
			this.initializeButton.Text = "Inicjalizacja";
			this.initializeButton.Click += new System.EventHandler(this.OnInitialize);
			// 
			// WeatherForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(408, 266);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.initializeButton,
																		  this.url});
			this.Name = "WeatherForm";
			this.Text = "Pogoda";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new WeatherForm());
		}

		private void SoapSuds(object s)
		{
			string path = (string)s;
			string assemblyFile = "weather.dll";

			try
			{
				MemoryStream ms = new MemoryStream();
				MetaData.RetrieveSchemaFromUrlToStream(path, ms);
				ms.Seek(0, SeekOrigin.Begin);
				ArrayList sa = new ArrayList();
				MetaData.ConvertSchemaStreamToCodeSourceStream(false, ".", ms, sa, null, "CLRUnleashed.Weather");
				MetaData.ConvertCodeSourceStreamToAssemblyFile(sa, assemblyFile, "");
				ms.Close();

				Assembly a = Assembly.LoadFrom(assemblyFile);
				Type t = a.GetType("CLRUnleashed.Weather.WeatherRetrieverSoap");
				MethodInfo m = t.GetMethod("GetTemperature",
					                       BindingFlags.Public | BindingFlags.Instance
					                       );
				ParameterInfo [] p = m.GetParameters();
				object o = Activator.CreateInstance(t);
				object result = m.Invoke(o, new object [] {"53717"});
				float temperature = (float)result;
			}
			catch(Exception e)
			{
				Debug.WriteLine(e);
			}
		}
		private void OnInitialize(object sender, System.EventArgs e)
		{
			try
			{
				ThreadPool.QueueUserWorkItem(new WaitCallback(SoapSuds), url.Text);
				// SoapSuds(url.Text);
			}
			catch(Exception exception)
			{
				Debug.WriteLine(exception);
			}
		}
	}
}
